import math
import urllib.request
import nltk
import os
from scipy import stats
import json
import pynvml

import numpy as np


def download_url(url, filepath):
    urllib.request.urlretrieve(url, filepath)


def pos_tags(tokens):
    x_tags = nltk.pos_tag(tokens)
    return list(list(zip(*x_tags))[1])


def softmax(x):
    x = [math.exp(i) for i in x]
    x_sum = sum(x)
    x = [i / x_sum for i in x]
    return x


def create_dir_of_file(file_path):
    dir_path = os.path.dirname(file_path)
    if not os.path.exists(dir_path):
        os.makedirs(dir_path)


def get_model_parm_nums(model):
    total = sum([param.nelement() for param in model.parameters()])
    return total


def mode(x, axis=0):
    return stats.mode(x, axis=axis)[0][0]


class NP2Json(json.JSONEncoder):
    def default(self, o):
        if isinstance(o, np.integer):
            return int(o)
        elif isinstance(o, np.floating):
            return float(o)
        elif isinstance(o, np.ndarray):
            return o.tolist()
        else:
            return super(NP2Json, self).default(o)


def set_similarity(x, y):
    x = set(x)
    y = set(y)
    return len(x & y) / len(x | y)


def write_json(path, data):
    create_dir_of_file(path)
    with open(path, 'w', encoding='utf-8') as f:
        json.dump(data, f, cls=NP2Json)


def read_json(path):
    with open(path, 'r', encoding='utf-8') as f:
        data = json.load(f)
    return data
